;turmite.asm
;Bit Usage. 7,6 Turmite bits.  4,3,2 direction.  1,0 tile type.
;(Later I will use bit 5 for speed: 0 is normal speed, 1 is double.)
;As all non-turmite cells will have zero velocity, the state 4 
;will never arise.  I use this state as a "don't update" flag state.
;    Cell is the cell I update, Source is its state, Target is a cell
;    near Cell, Sink is Target's state, Mite & Tile are  new cell values I ;    compute.
;(1) Put Source in bl.  If Source is 4, don't change newbuffer Cell. Exit.
;(2) Else test Source against Turmite bits.  If these bits are zero,
;    copy Source to Cell in new Buffer and exit.
;(3) Else Source has nonzero Turmite bits.  Use direction bits to select
;    Target and load Sink in bh.
;(4) If Sink is a Turmite in oldbuff or in newbuff, reverse direction of
;	Source and put it in Cell.
;(5) Else use Source hi, Cell lo, as offset into .CA table to determine
;	Mite state.
;(6) Put Mite in Target position in New Buffer.
;(7) Put 4 in Target position in Old Buffer to signal no update.
;(8) Mask Source to get Tile and put Tile in Cell in Old and New Buffers.

.386
codes segment use16 byte
assume cs:codes
org 100h
turmite proc far
	mov	dx,320	;load row length counter
	push si
	lbyte:
		xor	bh,bh
		mov	bl,[bp]				; get right rotated Source
		cmp	bl,2					; is rt rot of don't-update-state?
		jne	updatecell			; no, do update.
		inc	di					; yes,adjust for skipped stosb
		jmp	noupdate				; and skip it.
		updatecell:
		mov	al,bl				; keep rt rot source read
		test	bl,60h				; any right rotated turmite bits?
		jz	loadnewcell			; no. copy Source direct.
		xor	al,8					; reverse rt rot Source's direction
		mov	si,bx				; rt rotated Source has 432 in 321
		and	si,000Eh				; 2*direction in si
		mov	si,fs:nabetable[si]		; offset to NW,N,NE,E,SE,S,SW,or W
		mov	bh,[bp+si]			; right rotated Sink
		test	bh,60h				; is Target a turmite in oldbuff?
		jnz	loadnewcell			; yes, don't go there.
		rol	bh,1					; unrotate Sink
		rol	bl,1					; unrotate Source
		mov	ah,[bx]				; look up Mite
		mov	bx,di				; offset of Cell in newbuff
		test byte ptr es:[bx+si],60h	; is Target a turmite in newbuff?
		jnz	loadnewcell			; yes. reversed Source to new Cell
		mov	es:[bx+si],ah			; put Mite in Target in newbuff
		mov	byte ptr [bp+si],2		;dnt-updte-st to Target in oldbuff
		and	al,81h				; mask rt rotated Source to Tile
		mov	[bp],al				; Tile in oldbuff Cell
		loadnewcell:
		stosb					; Source or Tile in newbuff Cell
		noupdate:
		inc	bp					; advance along row
		dec	dx					; more to update?
		jnz	lbyte				; if yes, keep on going
	pop	si
	ret
turmite endp
nabetable dw -323,-322,-321,1,323,322,321,-1
;nw,n,ne,e,se,s,sw,w
;I use this order so nabetable[v XOR 8] is opposite to nabetable[v]
codes ends
end turmite
