;swap.asm 
;First put EveryCell's eight bits in bl and put the eight
;bits of a single randomly selected neighbor into bh and use
;bx is offset into a lookup table in the .CA file generated by the
;program which calls gas.cao.  This will be new EveryCell.
;Then exchange bh and bl and use this as lookup into same .CA to
;find new nabe.  
;Second, after EveryCell's and nabes new cells value are computed,
;Gas swaps these two cell values.
;The rule runs its own randomizer, using Wolfram code 30.

        .386
codes segment use16 byte
assume cs:codes
org 100h
naber proc far
	mov	dx,320	;load row length counter
	push si
	mov  si,fs:shiftregister			; reseed shiftregister at
	xor  si,[bp+160]				; start of row.
	xor  si,[bp]
	or   si,fs:counter
	mov  fs:shiftregister,si
	inc  fs:counter
	lbyte:
          mov  si,fs:shiftregister      ; shiftregister is a sixteen    
          mov  ax,si				; bit 1-D CA running Wolfram
		mov  cx,si				; code 30.  si holds C
		ror  ax,1					; ax holds L, cx holds R.
          rol  cx,1					; NewC = L XOR (C OR R)
		or   si,cx				
		xor  si,ax				; each time we read shiftregister
          mov  fs:shiftregister,si		; we update it.
	     and  si,000Eh				; even number 2 to 14
		mov  si,fs:nabetable[si]      ; offset to NW,N,NE,W,E,SW,S,or SE
		mov  bh,[bp+si]			; load nabe in bh
		rol  bh,1					; adjust map state
		mov  bl,[bp]				; get self
	     rol  bl,1                     ; adjust map state
		mov  ah,[bx]                  ; look up new EveryCell state
          xchg bl,bh                    ; now view nabe as center 
 		mov  al,[bx]                  ; and look up new val for nabe
		mov  [bp+si],ah			; copy new to nabe in oldbuff
		mov  bx,di				; offset of EveryCell
          mov  es:[bx+si],ah 	          ; copy new to nabe in newbuff
		mov  [bp],al                  ; copy nabe to self in oldbuff
		stosb					; copy nabe to self in newbuff
		inc  bp					; advance along row
		dec  dx					; more to update?
		jnz  lbyte				; if yes, keep on going
	pop  si
	ret
naber endp
nabetable dw -323,-322,-321,-1,1,321,322,323
shiftregister dw 17h
counter dw 1
codes ends
end naber
